#include "FslTypes.h"
#include "derivative.h"

#ifndef _TFT_H_
  #define _TFT_H_


#define CS        PTED_PTED1       // Chip Select
#define RS        PTED_PTED2       // Data and Instruction Register Select
#define WR1       PTED_PTED3       // Write
#define RD1       PTHD_PTHD1
#define TFT_RESET PTJD_PTJD6       // TFT_RESET

#define VALOR(DATA)      PTED_PTED5=(DATA&0x01)>>0;\
                  PTED_PTED6=(DATA&0x02)>>1;\
                  PTED_PTED7=(DATA&0x04)>>2;\
                  PTFD_PTFD0=(DATA&0x08)>>3;\
                  PTFD_PTFD1=(DATA&0x10)>>4;\
                  PTFD_PTFD2=(DATA&0x20)>>5;\
                  PTJD_PTJD4=(DATA&0x40)>>6;\
                  PTJD_PTJD5=(DATA&0x80)>>7;\
                  
#define P_VALOR(P_DATA)    PTEDD_PTEDD5=(P_DATA&0x01)>>0;\
                  PTEDD_PTEDD6=(P_DATA&0x02)>>1;\
                  PTEDD_PTEDD7=(P_DATA&0x04)>>2;\
                  PTFDD_PTFDD0=(P_DATA&0x08)>>3;\
                  PTFDD_PTFDD1=(P_DATA&0x10)>>4;\
                  PTFDD_PTFDD2=(P_DATA&0x20)>>5;\
                  PTJDD_PTJDD4=(P_DATA&0x40)>>6;\
                  PTJDD_PTJDD5=(P_DATA&0x80)>>7;\
             


extern UINT16 i_sweep, j_sweep, cnt;
extern UINT8 v1, v2;
extern UINT8 chs;


void TFT_init(void);
void screen_sweep(void);
void delay(UINT16 n);
void delayTouch(UINT16 n);
void data_out(UINT8 i);
void comm_out(UINT8 j);
void Fulldisplay(UINT8 d1,UINT8 d2);
void dispPic(const UINT8 *lcd_string);
void colorArea(UINT8 xs, UINT8 xe, UINT8 ys, UINT8 ye, UINT8 d1, UINT8 d2);
void picArea(UINT8 xs, UINT8 xe, UINT8 ys, UINT8 ye, const UINT8 *lcd_string);

void plotECG(); 

void resetLCD();
void init_LCD();

#endif